"use strict";
const electron_1 = require("electron");
const url = require("url");
function start(event, message) {
    if (message.devtools) {
        webview.addEventListener("did-stop-loading", () => {
            webview.openDevTools();
        });
    }
    webview.src = `http://localhost:${message.serverPort}/#ws=${message.wsPort}&local_token=${message.localtoken}&electron=1`;
}
function openInBrowser(event) {
    const currentUrl = url.parse(webview.src);
    const newUrl = url.parse(event.url);
    if (newUrl.host !== currentUrl.host || newUrl.pathname !== currentUrl.pathname) {
        console.log("Opening external URL: " + event.url);
        event.preventDefault();
        electron_1.shell.openExternal(event.url);
    }
}
const webview = document.getElementById("webview");
webview.addEventListener('will-navigate', openInBrowser);
webview.addEventListener('new-window', openInBrowser);
electron_1.ipcRenderer.addListener("start", start);
